package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  SchemaMappingArn,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSchemaMappingResponse(
    description: Optional[Description] = Optional.Absent,
    mappedInputFields: Iterable[
      zio.aws.entityresolution.model.SchemaInputAttribute
    ],
    schemaArn: SchemaMappingArn,
    schemaName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingResponse = {
    import UpdateSchemaMappingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingResponse
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .mappedInputFields(mappedInputFields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .schemaArn(SchemaMappingArn.unwrap(schemaArn): java.lang.String)
      .schemaName(EntityName.unwrap(schemaName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.UpdateSchemaMappingResponse.ReadOnly =
    zio.aws.entityresolution.model.UpdateSchemaMappingResponse
      .wrap(buildAwsValue())
}
object UpdateSchemaMappingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.UpdateSchemaMappingResponse =
      zio.aws.entityresolution.model.UpdateSchemaMappingResponse(
        description.map(value => value),
        mappedInputFields.map { item =>
          item.asEditable
        },
        schemaArn,
        schemaName
      )
    def description: Optional[Description]
    def mappedInputFields
        : List[zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly]
    def schemaArn: SchemaMappingArn
    def schemaName: EntityName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMappedInputFields: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly
    ]] = ZIO.succeed(mappedInputFields)
    def getSchemaArn: ZIO[Any, Nothing, SchemaMappingArn] =
      ZIO.succeed(schemaArn)
    def getSchemaName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(schemaName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingResponse
  ) extends zio.aws.entityresolution.model.UpdateSchemaMappingResponse.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.entityresolution.model.primitives.Description(value)
      )
    override val mappedInputFields
        : List[zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly] =
      impl
        .mappedInputFields()
        .asScala
        .map { item =>
          zio.aws.entityresolution.model.SchemaInputAttribute.wrap(item)
        }
        .toList
    override val schemaArn: SchemaMappingArn =
      zio.aws.entityresolution.model.primitives
        .SchemaMappingArn(impl.schemaArn())
    override val schemaName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.schemaName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingResponse
  ): zio.aws.entityresolution.model.UpdateSchemaMappingResponse.ReadOnly =
    new Wrapper(impl)
}
