package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{EntityName, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSchemaMappingRequest(
    description: Optional[Description] = Optional.Absent,
    mappedInputFields: Iterable[
      zio.aws.entityresolution.model.SchemaInputAttribute
    ],
    schemaName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingRequest = {
    import UpdateSchemaMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .mappedInputFields(mappedInputFields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .schemaName(EntityName.unwrap(schemaName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.UpdateSchemaMappingRequest.ReadOnly =
    zio.aws.entityresolution.model.UpdateSchemaMappingRequest
      .wrap(buildAwsValue())
}
object UpdateSchemaMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.UpdateSchemaMappingRequest =
      zio.aws.entityresolution.model.UpdateSchemaMappingRequest(
        description.map(value => value),
        mappedInputFields.map { item =>
          item.asEditable
        },
        schemaName
      )
    def description: Optional[Description]
    def mappedInputFields
        : List[zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly]
    def schemaName: EntityName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMappedInputFields: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly
    ]] = ZIO.succeed(mappedInputFields)
    def getSchemaName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(schemaName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingRequest
  ) extends zio.aws.entityresolution.model.UpdateSchemaMappingRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.entityresolution.model.primitives.Description(value)
      )
    override val mappedInputFields
        : List[zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly] =
      impl
        .mappedInputFields()
        .asScala
        .map { item =>
          zio.aws.entityresolution.model.SchemaInputAttribute.wrap(item)
        }
        .toList
    override val schemaName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.schemaName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingRequest
  ): zio.aws.entityresolution.model.UpdateSchemaMappingRequest.ReadOnly =
    new Wrapper(impl)
}
