package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  IdMappingWorkflowArn,
  RoleArn,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateIdMappingWorkflowResponse(
    description: Optional[Description] = Optional.Absent,
    idMappingTechniques: zio.aws.entityresolution.model.IdMappingTechniques,
    inputSourceConfig: Iterable[
      zio.aws.entityresolution.model.IdMappingWorkflowInputSource
    ],
    outputSourceConfig: Iterable[
      zio.aws.entityresolution.model.IdMappingWorkflowOutputSource
    ],
    roleArn: RoleArn,
    workflowArn: IdMappingWorkflowArn,
    workflowName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowResponse = {
    import UpdateIdMappingWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowResponse
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .idMappingTechniques(idMappingTechniques.buildAwsValue())
      .inputSourceConfig(inputSourceConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .outputSourceConfig(outputSourceConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .workflowArn(IdMappingWorkflowArn.unwrap(workflowArn): java.lang.String)
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse.ReadOnly =
    zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse
      .wrap(buildAwsValue())
}
object UpdateIdMappingWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse =
      zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse(
        description.map(value => value),
        idMappingTechniques.asEditable,
        inputSourceConfig.map { item =>
          item.asEditable
        },
        outputSourceConfig.map { item =>
          item.asEditable
        },
        roleArn,
        workflowArn,
        workflowName
      )
    def description: Optional[Description]
    def idMappingTechniques
        : zio.aws.entityresolution.model.IdMappingTechniques.ReadOnly
    def inputSourceConfig: List[
      zio.aws.entityresolution.model.IdMappingWorkflowInputSource.ReadOnly
    ]
    def outputSourceConfig: List[
      zio.aws.entityresolution.model.IdMappingWorkflowOutputSource.ReadOnly
    ]
    def roleArn: RoleArn
    def workflowArn: IdMappingWorkflowArn
    def workflowName: EntityName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getIdMappingTechniques: ZIO[
      Any,
      Nothing,
      zio.aws.entityresolution.model.IdMappingTechniques.ReadOnly
    ] = ZIO.succeed(idMappingTechniques)
    def getInputSourceConfig: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.IdMappingWorkflowInputSource.ReadOnly
    ]] = ZIO.succeed(inputSourceConfig)
    def getOutputSourceConfig: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.IdMappingWorkflowOutputSource.ReadOnly
    ]] = ZIO.succeed(outputSourceConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getWorkflowArn: ZIO[Any, Nothing, IdMappingWorkflowArn] =
      ZIO.succeed(workflowArn)
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowResponse
  ) extends zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.entityresolution.model.primitives.Description(value)
      )
    override val idMappingTechniques
        : zio.aws.entityresolution.model.IdMappingTechniques.ReadOnly =
      zio.aws.entityresolution.model.IdMappingTechniques
        .wrap(impl.idMappingTechniques())
    override val inputSourceConfig: List[
      zio.aws.entityresolution.model.IdMappingWorkflowInputSource.ReadOnly
    ] = impl
      .inputSourceConfig()
      .asScala
      .map { item =>
        zio.aws.entityresolution.model.IdMappingWorkflowInputSource.wrap(item)
      }
      .toList
    override val outputSourceConfig: List[
      zio.aws.entityresolution.model.IdMappingWorkflowOutputSource.ReadOnly
    ] = impl
      .outputSourceConfig()
      .asScala
      .map { item =>
        zio.aws.entityresolution.model.IdMappingWorkflowOutputSource.wrap(item)
      }
      .toList
    override val roleArn: RoleArn =
      zio.aws.entityresolution.model.primitives.RoleArn(impl.roleArn())
    override val workflowArn: IdMappingWorkflowArn =
      zio.aws.entityresolution.model.primitives
        .IdMappingWorkflowArn(impl.workflowArn())
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowResponse
  ): zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse.ReadOnly =
    new Wrapper(impl)
}
