package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{TagKey, VeniceGlobalArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: VeniceGlobalArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.UntagResourceRequest
      .builder()
      .resourceArn(VeniceGlobalArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.UntagResourceRequest.ReadOnly =
    zio.aws.entityresolution.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.UntagResourceRequest =
      zio.aws.entityresolution.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: VeniceGlobalArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, VeniceGlobalArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.UntagResourceRequest
  ) extends zio.aws.entityresolution.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: VeniceGlobalArn =
      zio.aws.entityresolution.model.primitives
        .VeniceGlobalArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.entityresolution.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.UntagResourceRequest
  ): zio.aws.entityresolution.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
