package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  TagValue,
  TagKey,
  VeniceGlobalArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: VeniceGlobalArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.TagResourceRequest
      .builder()
      .resourceArn(VeniceGlobalArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.TagResourceRequest.ReadOnly =
    zio.aws.entityresolution.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.TagResourceRequest =
      zio.aws.entityresolution.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: VeniceGlobalArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, VeniceGlobalArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.TagResourceRequest
  ) extends zio.aws.entityresolution.model.TagResourceRequest.ReadOnly {
    override val resourceArn: VeniceGlobalArn =
      zio.aws.entityresolution.model.primitives
        .VeniceGlobalArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.entityresolution.model.primitives.TagKey(
          key
        ) -> zio.aws.entityresolution.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.TagResourceRequest
  ): zio.aws.entityresolution.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
