package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartMatchingJobResponse(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.StartMatchingJobResponse = {
    import StartMatchingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.StartMatchingJobResponse
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.StartMatchingJobResponse.ReadOnly =
    zio.aws.entityresolution.model.StartMatchingJobResponse
      .wrap(buildAwsValue())
}
object StartMatchingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.StartMatchingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.StartMatchingJobResponse =
      zio.aws.entityresolution.model.StartMatchingJobResponse(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.StartMatchingJobResponse
  ) extends zio.aws.entityresolution.model.StartMatchingJobResponse.ReadOnly {
    override val jobId: JobId =
      zio.aws.entityresolution.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.StartMatchingJobResponse
  ): zio.aws.entityresolution.model.StartMatchingJobResponse.ReadOnly =
    new Wrapper(impl)
}
