package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.EntityName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartMatchingJobRequest(workflowName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.StartMatchingJobRequest = {
    import StartMatchingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.StartMatchingJobRequest
      .builder()
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.StartMatchingJobRequest.ReadOnly =
    zio.aws.entityresolution.model.StartMatchingJobRequest.wrap(buildAwsValue())
}
object StartMatchingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.StartMatchingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.StartMatchingJobRequest =
      zio.aws.entityresolution.model.StartMatchingJobRequest(workflowName)
    def workflowName: EntityName
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.StartMatchingJobRequest
  ) extends zio.aws.entityresolution.model.StartMatchingJobRequest.ReadOnly {
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.StartMatchingJobRequest
  ): zio.aws.entityresolution.model.StartMatchingJobRequest.ReadOnly =
    new Wrapper(impl)
}
