package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartIdMappingJobResponse(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobResponse = {
    import StartIdMappingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobResponse
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.StartIdMappingJobResponse.ReadOnly =
    zio.aws.entityresolution.model.StartIdMappingJobResponse
      .wrap(buildAwsValue())
}
object StartIdMappingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.StartIdMappingJobResponse =
      zio.aws.entityresolution.model.StartIdMappingJobResponse(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobResponse
  ) extends zio.aws.entityresolution.model.StartIdMappingJobResponse.ReadOnly {
    override val jobId: JobId =
      zio.aws.entityresolution.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobResponse
  ): zio.aws.entityresolution.model.StartIdMappingJobResponse.ReadOnly =
    new Wrapper(impl)
}
