package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.EntityName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartIdMappingJobRequest(workflowName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobRequest = {
    import StartIdMappingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobRequest
      .builder()
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.StartIdMappingJobRequest.ReadOnly =
    zio.aws.entityresolution.model.StartIdMappingJobRequest
      .wrap(buildAwsValue())
}
object StartIdMappingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.StartIdMappingJobRequest =
      zio.aws.entityresolution.model.StartIdMappingJobRequest(workflowName)
    def workflowName: EntityName
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobRequest
  ) extends zio.aws.entityresolution.model.StartIdMappingJobRequest.ReadOnly {
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobRequest
  ): zio.aws.entityresolution.model.StartIdMappingJobRequest.ReadOnly =
    new Wrapper(impl)
}
