package zio.aws.entityresolution.model
import scala.jdk.CollectionConverters._
sealed trait ServiceType {
  def unwrap: software.amazon.awssdk.services.entityresolution.model.ServiceType
}
object ServiceType {
  def wrap(
      value: software.amazon.awssdk.services.entityresolution.model.ServiceType
  ): zio.aws.entityresolution.model.ServiceType = value match {
    case software.amazon.awssdk.services.entityresolution.model.ServiceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.entityresolution.model.ServiceType.ASSIGNMENT =>
      val r = ASSIGNMENT
      r
    case software.amazon.awssdk.services.entityresolution.model.ServiceType.ID_MAPPING =>
      val r = ID_MAPPING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.entityresolution.model.ServiceType {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.ServiceType =
      software.amazon.awssdk.services.entityresolution.model.ServiceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSIGNMENT extends zio.aws.entityresolution.model.ServiceType {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.ServiceType =
      software.amazon.awssdk.services.entityresolution.model.ServiceType.ASSIGNMENT
  }
  case object ID_MAPPING extends zio.aws.entityresolution.model.ServiceType {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.ServiceType =
      software.amazon.awssdk.services.entityresolution.model.ServiceType.ID_MAPPING
  }
}
