package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  SchemaMappingArn,
  Timestamp
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SchemaMappingSummary(
    createdAt: Timestamp,
    hasWorkflows: Boolean,
    schemaArn: SchemaMappingArn,
    schemaName: EntityName,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary = {
    import SchemaMappingSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary
      .builder()
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .hasWorkflows(hasWorkflows: java.lang.Boolean)
      .schemaArn(SchemaMappingArn.unwrap(schemaArn): java.lang.String)
      .schemaName(EntityName.unwrap(schemaName): java.lang.String)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.SchemaMappingSummary.ReadOnly =
    zio.aws.entityresolution.model.SchemaMappingSummary.wrap(buildAwsValue())
}
object SchemaMappingSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.SchemaMappingSummary =
      zio.aws.entityresolution.model.SchemaMappingSummary(
        createdAt,
        hasWorkflows,
        schemaArn,
        schemaName,
        updatedAt
      )
    def createdAt: Timestamp
    def hasWorkflows: Boolean
    def schemaArn: SchemaMappingArn
    def schemaName: EntityName
    def updatedAt: Timestamp
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getHasWorkflows: ZIO[Any, Nothing, Boolean] = ZIO.succeed(hasWorkflows)
    def getSchemaArn: ZIO[Any, Nothing, SchemaMappingArn] =
      ZIO.succeed(schemaArn)
    def getSchemaName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(schemaName)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary
  ) extends zio.aws.entityresolution.model.SchemaMappingSummary.ReadOnly {
    override val createdAt: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.createdAt())
    override val hasWorkflows: Boolean = impl.hasWorkflows(): Boolean
    override val schemaArn: SchemaMappingArn =
      zio.aws.entityresolution.model.primitives
        .SchemaMappingArn(impl.schemaArn())
    override val schemaName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.schemaName())
    override val updatedAt: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary
  ): zio.aws.entityresolution.model.SchemaMappingSummary.ReadOnly = new Wrapper(
    impl
  )
}
