package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.AttributeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SchemaInputAttribute(
    fieldName: AttributeName,
    groupName: Optional[AttributeName] = Optional.Absent,
    matchKey: Optional[AttributeName] = Optional.Absent,
    subType: Optional[AttributeName] = Optional.Absent,
    `type`: zio.aws.entityresolution.model.SchemaAttributeType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute = {
    import SchemaInputAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute
      .builder()
      .fieldName(AttributeName.unwrap(fieldName): java.lang.String)
      .optionallyWith(
        groupName.map(value => AttributeName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        matchKey.map(value => AttributeName.unwrap(value): java.lang.String)
      )(_.matchKey)
      .optionallyWith(
        subType.map(value => AttributeName.unwrap(value): java.lang.String)
      )(_.subType)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly =
    zio.aws.entityresolution.model.SchemaInputAttribute.wrap(buildAwsValue())
}
object SchemaInputAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.SchemaInputAttribute =
      zio.aws.entityresolution.model.SchemaInputAttribute(
        fieldName,
        groupName.map(value => value),
        matchKey.map(value => value),
        subType.map(value => value),
        `type`
      )
    def fieldName: AttributeName
    def groupName: Optional[AttributeName]
    def matchKey: Optional[AttributeName]
    def subType: Optional[AttributeName]
    def `type`: zio.aws.entityresolution.model.SchemaAttributeType
    def getFieldName: ZIO[Any, Nothing, AttributeName] = ZIO.succeed(fieldName)
    def getGroupName: ZIO[Any, AwsError, AttributeName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getMatchKey: ZIO[Any, AwsError, AttributeName] =
      AwsError.unwrapOptionField("matchKey", matchKey)
    def getSubType: ZIO[Any, AwsError, AttributeName] =
      AwsError.unwrapOptionField("subType", subType)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.entityresolution.model.SchemaAttributeType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute
  ) extends zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly {
    override val fieldName: AttributeName =
      zio.aws.entityresolution.model.primitives.AttributeName(impl.fieldName())
    override val groupName: Optional[AttributeName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value =>
        zio.aws.entityresolution.model.primitives.AttributeName(value)
      )
    override val matchKey: Optional[AttributeName] = zio.aws.core.internal
      .optionalFromNullable(impl.matchKey())
      .map(value =>
        zio.aws.entityresolution.model.primitives.AttributeName(value)
      )
    override val subType: Optional[AttributeName] = zio.aws.core.internal
      .optionalFromNullable(impl.subType())
      .map(value =>
        zio.aws.entityresolution.model.primitives.AttributeName(value)
      )
    override val `type`: zio.aws.entityresolution.model.SchemaAttributeType =
      zio.aws.entityresolution.model.SchemaAttributeType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute
  ): zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly = new Wrapper(
    impl
  )
}
