package zio.aws.entityresolution.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RuleBasedProperties(
    attributeMatchingModel: zio.aws.entityresolution.model.AttributeMatchingModel,
    rules: Iterable[zio.aws.entityresolution.model.Rule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.RuleBasedProperties = {
    import RuleBasedProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.RuleBasedProperties
      .builder()
      .attributeMatchingModel(attributeMatchingModel.unwrap)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.RuleBasedProperties.ReadOnly =
    zio.aws.entityresolution.model.RuleBasedProperties.wrap(buildAwsValue())
}
object RuleBasedProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.RuleBasedProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.RuleBasedProperties =
      zio.aws.entityresolution.model.RuleBasedProperties(
        attributeMatchingModel,
        rules.map { item =>
          item.asEditable
        }
      )
    def attributeMatchingModel
        : zio.aws.entityresolution.model.AttributeMatchingModel
    def rules: List[zio.aws.entityresolution.model.Rule.ReadOnly]
    def getAttributeMatchingModel: ZIO[
      Any,
      Nothing,
      zio.aws.entityresolution.model.AttributeMatchingModel
    ] = ZIO.succeed(attributeMatchingModel)
    def getRules: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.Rule.ReadOnly
    ]] = ZIO.succeed(rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.RuleBasedProperties
  ) extends zio.aws.entityresolution.model.RuleBasedProperties.ReadOnly {
    override val attributeMatchingModel
        : zio.aws.entityresolution.model.AttributeMatchingModel =
      zio.aws.entityresolution.model.AttributeMatchingModel
        .wrap(impl.attributeMatchingModel())
    override val rules: List[zio.aws.entityresolution.model.Rule.ReadOnly] =
      impl
        .rules()
        .asScala
        .map { item =>
          zio.aws.entityresolution.model.Rule.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.RuleBasedProperties
  ): zio.aws.entityresolution.model.RuleBasedProperties.ReadOnly = new Wrapper(
    impl
  )
}
