package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  RuleRuleNameString,
  AttributeName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Rule(
    matchingKeys: Iterable[AttributeName],
    ruleName: RuleRuleNameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.Rule
      .builder()
      .matchingKeys(matchingKeys.map { item =>
        AttributeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .ruleName(RuleRuleNameString.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.Rule.ReadOnly =
    zio.aws.entityresolution.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.Rule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.Rule =
      zio.aws.entityresolution.model.Rule(matchingKeys, ruleName)
    def matchingKeys: List[AttributeName]
    def ruleName: RuleRuleNameString
    def getMatchingKeys: ZIO[Any, Nothing, List[AttributeName]] =
      ZIO.succeed(matchingKeys)
    def getRuleName: ZIO[Any, Nothing, RuleRuleNameString] =
      ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.Rule
  ) extends zio.aws.entityresolution.model.Rule.ReadOnly {
    override val matchingKeys: List[AttributeName] = impl
      .matchingKeys()
      .asScala
      .map { item =>
        zio.aws.entityresolution.model.primitives.AttributeName(item)
      }
      .toList
    override val ruleName: RuleRuleNameString =
      zio.aws.entityresolution.model.primitives
        .RuleRuleNameString(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.Rule
  ): zio.aws.entityresolution.model.Rule.ReadOnly = new Wrapper(impl)
}
