package zio.aws.entityresolution.model
import scala.jdk.CollectionConverters._
sealed trait ResolutionType {
  def unwrap
      : software.amazon.awssdk.services.entityresolution.model.ResolutionType
}
object ResolutionType {
  def wrap(
      value: software.amazon.awssdk.services.entityresolution.model.ResolutionType
  ): zio.aws.entityresolution.model.ResolutionType = value match {
    case software.amazon.awssdk.services.entityresolution.model.ResolutionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.entityresolution.model.ResolutionType.RULE_MATCHING =>
      val r = RULE_MATCHING
      r
    case software.amazon.awssdk.services.entityresolution.model.ResolutionType.ML_MATCHING =>
      val r = ML_MATCHING
      r
    case software.amazon.awssdk.services.entityresolution.model.ResolutionType.PROVIDER =>
      val r = PROVIDER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.entityresolution.model.ResolutionType {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.ResolutionType =
      software.amazon.awssdk.services.entityresolution.model.ResolutionType.UNKNOWN_TO_SDK_VERSION
  }
  case object RULE_MATCHING
      extends zio.aws.entityresolution.model.ResolutionType {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.ResolutionType =
      software.amazon.awssdk.services.entityresolution.model.ResolutionType.RULE_MATCHING
  }
  case object ML_MATCHING
      extends zio.aws.entityresolution.model.ResolutionType {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.ResolutionType =
      software.amazon.awssdk.services.entityresolution.model.ResolutionType.ML_MATCHING
  }
  case object PROVIDER extends zio.aws.entityresolution.model.ResolutionType {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.ResolutionType =
      software.amazon.awssdk.services.entityresolution.model.ResolutionType.PROVIDER
  }
}
