package zio.aws.entityresolution.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResolutionTechniques(
    providerProperties: Optional[
      zio.aws.entityresolution.model.ProviderProperties
    ] = Optional.Absent,
    resolutionType: zio.aws.entityresolution.model.ResolutionType,
    ruleBasedProperties: Optional[
      zio.aws.entityresolution.model.RuleBasedProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ResolutionTechniques = {
    import ResolutionTechniques.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ResolutionTechniques
      .builder()
      .optionallyWith(providerProperties.map(value => value.buildAwsValue()))(
        _.providerProperties
      )
      .resolutionType(resolutionType.unwrap)
      .optionallyWith(ruleBasedProperties.map(value => value.buildAwsValue()))(
        _.ruleBasedProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.ResolutionTechniques.ReadOnly =
    zio.aws.entityresolution.model.ResolutionTechniques.wrap(buildAwsValue())
}
object ResolutionTechniques {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ResolutionTechniques
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ResolutionTechniques =
      zio.aws.entityresolution.model.ResolutionTechniques(
        providerProperties.map(value => value.asEditable),
        resolutionType,
        ruleBasedProperties.map(value => value.asEditable)
      )
    def providerProperties
        : Optional[zio.aws.entityresolution.model.ProviderProperties.ReadOnly]
    def resolutionType: zio.aws.entityresolution.model.ResolutionType
    def ruleBasedProperties
        : Optional[zio.aws.entityresolution.model.RuleBasedProperties.ReadOnly]
    def getProviderProperties: ZIO[
      Any,
      AwsError,
      zio.aws.entityresolution.model.ProviderProperties.ReadOnly
    ] = AwsError.unwrapOptionField("providerProperties", providerProperties)
    def getResolutionType
        : ZIO[Any, Nothing, zio.aws.entityresolution.model.ResolutionType] =
      ZIO.succeed(resolutionType)
    def getRuleBasedProperties: ZIO[
      Any,
      AwsError,
      zio.aws.entityresolution.model.RuleBasedProperties.ReadOnly
    ] = AwsError.unwrapOptionField("ruleBasedProperties", ruleBasedProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ResolutionTechniques
  ) extends zio.aws.entityresolution.model.ResolutionTechniques.ReadOnly {
    override val providerProperties
        : Optional[zio.aws.entityresolution.model.ProviderProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerProperties())
        .map(value =>
          zio.aws.entityresolution.model.ProviderProperties.wrap(value)
        )
    override val resolutionType: zio.aws.entityresolution.model.ResolutionType =
      zio.aws.entityresolution.model.ResolutionType.wrap(impl.resolutionType())
    override val ruleBasedProperties: Optional[
      zio.aws.entityresolution.model.RuleBasedProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleBasedProperties())
      .map(value =>
        zio.aws.entityresolution.model.RuleBasedProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ResolutionTechniques
  ): zio.aws.entityresolution.model.ResolutionTechniques.ReadOnly = new Wrapper(
    impl
  )
}
