package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  ProviderServiceDisplayName,
  ProviderServiceArn,
  EntityName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ProviderServiceSummary(
    providerName: EntityName,
    providerServiceArn: ProviderServiceArn,
    providerServiceDisplayName: ProviderServiceDisplayName,
    providerServiceName: EntityName,
    providerServiceType: zio.aws.entityresolution.model.ServiceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary = {
    import ProviderServiceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary
      .builder()
      .providerName(EntityName.unwrap(providerName): java.lang.String)
      .providerServiceArn(
        ProviderServiceArn.unwrap(providerServiceArn): java.lang.String
      )
      .providerServiceDisplayName(
        ProviderServiceDisplayName.unwrap(
          providerServiceDisplayName
        ): java.lang.String
      )
      .providerServiceName(
        EntityName.unwrap(providerServiceName): java.lang.String
      )
      .providerServiceType(providerServiceType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ProviderServiceSummary.ReadOnly =
    zio.aws.entityresolution.model.ProviderServiceSummary.wrap(buildAwsValue())
}
object ProviderServiceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ProviderServiceSummary =
      zio.aws.entityresolution.model.ProviderServiceSummary(
        providerName,
        providerServiceArn,
        providerServiceDisplayName,
        providerServiceName,
        providerServiceType
      )
    def providerName: EntityName
    def providerServiceArn: ProviderServiceArn
    def providerServiceDisplayName: ProviderServiceDisplayName
    def providerServiceName: EntityName
    def providerServiceType: zio.aws.entityresolution.model.ServiceType
    def getProviderName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(providerName)
    def getProviderServiceArn: ZIO[Any, Nothing, ProviderServiceArn] =
      ZIO.succeed(providerServiceArn)
    def getProviderServiceDisplayName
        : ZIO[Any, Nothing, ProviderServiceDisplayName] =
      ZIO.succeed(providerServiceDisplayName)
    def getProviderServiceName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(providerServiceName)
    def getProviderServiceType
        : ZIO[Any, Nothing, zio.aws.entityresolution.model.ServiceType] =
      ZIO.succeed(providerServiceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary
  ) extends zio.aws.entityresolution.model.ProviderServiceSummary.ReadOnly {
    override val providerName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.providerName())
    override val providerServiceArn: ProviderServiceArn =
      zio.aws.entityresolution.model.primitives
        .ProviderServiceArn(impl.providerServiceArn())
    override val providerServiceDisplayName: ProviderServiceDisplayName =
      zio.aws.entityresolution.model.primitives
        .ProviderServiceDisplayName(impl.providerServiceDisplayName())
    override val providerServiceName: EntityName =
      zio.aws.entityresolution.model.primitives
        .EntityName(impl.providerServiceName())
    override val providerServiceType
        : zio.aws.entityresolution.model.ServiceType =
      zio.aws.entityresolution.model.ServiceType
        .wrap(impl.providerServiceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary
  ): zio.aws.entityresolution.model.ProviderServiceSummary.ReadOnly =
    new Wrapper(impl)
}
