package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.ProviderServiceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProviderProperties(
    intermediateSourceConfiguration: Optional[
      zio.aws.entityresolution.model.IntermediateSourceConfiguration
    ] = Optional.Absent,
    providerConfiguration: Optional[zio.aws.entityresolution.model.Document] =
      Optional.Absent,
    providerServiceArn: ProviderServiceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ProviderProperties = {
    import ProviderProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ProviderProperties
      .builder()
      .optionallyWith(
        intermediateSourceConfiguration.map(value => value.buildAwsValue())
      )(_.intermediateSourceConfiguration)
      .optionallyWith(providerConfiguration.map(value => value))(
        _.providerConfiguration
      )
      .providerServiceArn(
        ProviderServiceArn.unwrap(providerServiceArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.ProviderProperties.ReadOnly =
    zio.aws.entityresolution.model.ProviderProperties.wrap(buildAwsValue())
}
object ProviderProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ProviderProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ProviderProperties =
      zio.aws.entityresolution.model.ProviderProperties(
        intermediateSourceConfiguration.map(value => value.asEditable),
        providerConfiguration.map(value => value),
        providerServiceArn
      )
    def intermediateSourceConfiguration: Optional[
      zio.aws.entityresolution.model.IntermediateSourceConfiguration.ReadOnly
    ]
    def providerConfiguration
        : Optional[software.amazon.awssdk.core.document.Document]
    def providerServiceArn: ProviderServiceArn
    def getIntermediateSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.entityresolution.model.IntermediateSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "intermediateSourceConfiguration",
      intermediateSourceConfiguration
    )
    def getProviderConfiguration
        : ZIO[Any, AwsError, software.amazon.awssdk.core.document.Document] =
      AwsError.unwrapOptionField("providerConfiguration", providerConfiguration)
    def getProviderServiceArn: ZIO[Any, Nothing, ProviderServiceArn] =
      ZIO.succeed(providerServiceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ProviderProperties
  ) extends zio.aws.entityresolution.model.ProviderProperties.ReadOnly {
    override val intermediateSourceConfiguration: Optional[
      zio.aws.entityresolution.model.IntermediateSourceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.intermediateSourceConfiguration())
      .map(value =>
        zio.aws.entityresolution.model.IntermediateSourceConfiguration
          .wrap(value)
      )
    override val providerConfiguration
        : Optional[software.amazon.awssdk.core.document.Document] =
      zio.aws.core.internal.optionalFromNullable(impl.providerConfiguration())
    override val providerServiceArn: ProviderServiceArn =
      zio.aws.entityresolution.model.primitives
        .ProviderServiceArn(impl.providerServiceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ProviderProperties
  ): zio.aws.entityresolution.model.ProviderProperties.ReadOnly = new Wrapper(
    impl
  )
}
