package zio.aws.entityresolution.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ProviderMarketplaceConfiguration(
    assetId: String,
    dataSetId: String,
    listingId: String,
    revisionId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ProviderMarketplaceConfiguration = {
    import ProviderMarketplaceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ProviderMarketplaceConfiguration
      .builder()
      .assetId(assetId: java.lang.String)
      .dataSetId(dataSetId: java.lang.String)
      .listingId(listingId: java.lang.String)
      .revisionId(revisionId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ProviderMarketplaceConfiguration.ReadOnly =
    zio.aws.entityresolution.model.ProviderMarketplaceConfiguration
      .wrap(buildAwsValue())
}
object ProviderMarketplaceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ProviderMarketplaceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.ProviderMarketplaceConfiguration =
      zio.aws.entityresolution.model.ProviderMarketplaceConfiguration(
        assetId,
        dataSetId,
        listingId,
        revisionId
      )
    def assetId: String
    def dataSetId: String
    def listingId: String
    def revisionId: String
    def getAssetId: ZIO[Any, Nothing, String] = ZIO.succeed(assetId)
    def getDataSetId: ZIO[Any, Nothing, String] = ZIO.succeed(dataSetId)
    def getListingId: ZIO[Any, Nothing, String] = ZIO.succeed(listingId)
    def getRevisionId: ZIO[Any, Nothing, String] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ProviderMarketplaceConfiguration
  ) extends zio.aws.entityresolution.model.ProviderMarketplaceConfiguration.ReadOnly {
    override val assetId: String = impl.assetId(): String
    override val dataSetId: String = impl.dataSetId(): String
    override val listingId: String = impl.listingId(): String
    override val revisionId: String = impl.revisionId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ProviderMarketplaceConfiguration
  ): zio.aws.entityresolution.model.ProviderMarketplaceConfiguration.ReadOnly =
    new Wrapper(impl)
}
