package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.AwsAccountId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProviderIntermediateDataAccessConfiguration(
    awsAccountIds: Optional[Iterable[AwsAccountId]] = Optional.Absent,
    requiredBucketActions: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ProviderIntermediateDataAccessConfiguration = {
    import ProviderIntermediateDataAccessConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ProviderIntermediateDataAccessConfiguration
      .builder()
      .optionallyWith(
        awsAccountIds.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.awsAccountIds)
      .optionallyWith(
        requiredBucketActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.requiredBucketActions)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ProviderIntermediateDataAccessConfiguration.ReadOnly =
    zio.aws.entityresolution.model.ProviderIntermediateDataAccessConfiguration
      .wrap(buildAwsValue())
}
object ProviderIntermediateDataAccessConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ProviderIntermediateDataAccessConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.ProviderIntermediateDataAccessConfiguration =
      zio.aws.entityresolution.model
        .ProviderIntermediateDataAccessConfiguration(
          awsAccountIds.map(value => value),
          requiredBucketActions.map(value => value)
        )
    def awsAccountIds: Optional[List[AwsAccountId]]
    def requiredBucketActions: Optional[List[String]]
    def getAwsAccountIds: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField("awsAccountIds", awsAccountIds)
    def getRequiredBucketActions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("requiredBucketActions", requiredBucketActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ProviderIntermediateDataAccessConfiguration
  ) extends zio.aws.entityresolution.model.ProviderIntermediateDataAccessConfiguration.ReadOnly {
    override val awsAccountIds: Optional[List[AwsAccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsAccountIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.entityresolution.model.primitives.AwsAccountId(item)
          }.toList
        )
    override val requiredBucketActions: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiredBucketActions())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ProviderIntermediateDataAccessConfiguration
  ): zio.aws.entityresolution.model.ProviderIntermediateDataAccessConfiguration.ReadOnly =
    new Wrapper(impl)
}
