package zio.aws.entityresolution.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProviderEndpointConfiguration(
    marketplaceConfiguration: Optional[
      zio.aws.entityresolution.model.ProviderMarketplaceConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ProviderEndpointConfiguration = {
    import ProviderEndpointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ProviderEndpointConfiguration
      .builder()
      .optionallyWith(
        marketplaceConfiguration.map(value => value.buildAwsValue())
      )(_.marketplaceConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ProviderEndpointConfiguration.ReadOnly =
    zio.aws.entityresolution.model.ProviderEndpointConfiguration
      .wrap(buildAwsValue())
}
object ProviderEndpointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ProviderEndpointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.ProviderEndpointConfiguration =
      zio.aws.entityresolution.model.ProviderEndpointConfiguration(
        marketplaceConfiguration.map(value => value.asEditable)
      )
    def marketplaceConfiguration: Optional[
      zio.aws.entityresolution.model.ProviderMarketplaceConfiguration.ReadOnly
    ]
    def getMarketplaceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.entityresolution.model.ProviderMarketplaceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "marketplaceConfiguration",
      marketplaceConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ProviderEndpointConfiguration
  ) extends zio.aws.entityresolution.model.ProviderEndpointConfiguration.ReadOnly {
    override val marketplaceConfiguration: Optional[
      zio.aws.entityresolution.model.ProviderMarketplaceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.marketplaceConfiguration())
      .map(value =>
        zio.aws.entityresolution.model.ProviderMarketplaceConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ProviderEndpointConfiguration
  ): zio.aws.entityresolution.model.ProviderEndpointConfiguration.ReadOnly =
    new Wrapper(impl)
}
