package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{S3Path, KMSArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutputSource(
    kmsArn: Optional[KMSArn] = Optional.Absent,
    applyNormalization: Optional[Boolean] = Optional.Absent,
    output: Iterable[zio.aws.entityresolution.model.OutputAttribute],
    outputS3Path: S3Path
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.OutputSource = {
    import OutputSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.OutputSource
      .builder()
      .optionallyWith(
        kmsArn.map(value => KMSArn.unwrap(value): java.lang.String)
      )(_.kmsArn)
      .optionallyWith(
        applyNormalization.map(value => value: java.lang.Boolean)
      )(_.applyNormalization)
      .output(output.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .outputS3Path(S3Path.unwrap(outputS3Path): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.OutputSource.ReadOnly =
    zio.aws.entityresolution.model.OutputSource.wrap(buildAwsValue())
}
object OutputSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.OutputSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.OutputSource =
      zio.aws.entityresolution.model.OutputSource(
        kmsArn.map(value => value),
        applyNormalization.map(value => value),
        output.map { item =>
          item.asEditable
        },
        outputS3Path
      )
    def kmsArn: Optional[KMSArn]
    def applyNormalization: Optional[Boolean]
    def output: List[zio.aws.entityresolution.model.OutputAttribute.ReadOnly]
    def outputS3Path: S3Path
    def getKmsArn: ZIO[Any, AwsError, KMSArn] =
      AwsError.unwrapOptionField("kmsArn", kmsArn)
    def getApplyNormalization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyNormalization", applyNormalization)
    def getOutput: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.OutputAttribute.ReadOnly
    ]] = ZIO.succeed(output)
    def getOutputS3Path: ZIO[Any, Nothing, S3Path] = ZIO.succeed(outputS3Path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.OutputSource
  ) extends zio.aws.entityresolution.model.OutputSource.ReadOnly {
    override val kmsArn: Optional[KMSArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsArn())
      .map(value => zio.aws.entityresolution.model.primitives.KMSArn(value))
    override val applyNormalization: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyNormalization())
      .map(value => value: Boolean)
    override val output
        : List[zio.aws.entityresolution.model.OutputAttribute.ReadOnly] = impl
      .output()
      .asScala
      .map { item =>
        zio.aws.entityresolution.model.OutputAttribute.wrap(item)
      }
      .toList
    override val outputS3Path: S3Path =
      zio.aws.entityresolution.model.primitives.S3Path(impl.outputS3Path())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.OutputSource
  ): zio.aws.entityresolution.model.OutputSource.ReadOnly = new Wrapper(impl)
}
