package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.AttributeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutputAttribute(
    hashed: Optional[Boolean] = Optional.Absent,
    name: AttributeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.OutputAttribute = {
    import OutputAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.OutputAttribute
      .builder()
      .optionallyWith(hashed.map(value => value: java.lang.Boolean))(_.hashed)
      .name(AttributeName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.OutputAttribute.ReadOnly =
    zio.aws.entityresolution.model.OutputAttribute.wrap(buildAwsValue())
}
object OutputAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.OutputAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.OutputAttribute =
      zio.aws.entityresolution.model
        .OutputAttribute(hashed.map(value => value), name)
    def hashed: Optional[Boolean]
    def name: AttributeName
    def getHashed: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hashed", hashed)
    def getName: ZIO[Any, Nothing, AttributeName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.OutputAttribute
  ) extends zio.aws.entityresolution.model.OutputAttribute.ReadOnly {
    override val hashed: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hashed())
      .map(value => value: Boolean)
    override val name: AttributeName =
      zio.aws.entityresolution.model.primitives.AttributeName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.OutputAttribute
  ): zio.aws.entityresolution.model.OutputAttribute.ReadOnly = new Wrapper(impl)
}
