package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  MatchingWorkflowArn,
  Timestamp
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class MatchingWorkflowSummary(
    createdAt: Timestamp,
    resolutionType: zio.aws.entityresolution.model.ResolutionType,
    updatedAt: Timestamp,
    workflowArn: MatchingWorkflowArn,
    workflowName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary = {
    import MatchingWorkflowSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary
      .builder()
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .resolutionType(resolutionType.unwrap)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .workflowArn(MatchingWorkflowArn.unwrap(workflowArn): java.lang.String)
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.MatchingWorkflowSummary.ReadOnly =
    zio.aws.entityresolution.model.MatchingWorkflowSummary.wrap(buildAwsValue())
}
object MatchingWorkflowSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.MatchingWorkflowSummary =
      zio.aws.entityresolution.model.MatchingWorkflowSummary(
        createdAt,
        resolutionType,
        updatedAt,
        workflowArn,
        workflowName
      )
    def createdAt: Timestamp
    def resolutionType: zio.aws.entityresolution.model.ResolutionType
    def updatedAt: Timestamp
    def workflowArn: MatchingWorkflowArn
    def workflowName: EntityName
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getResolutionType
        : ZIO[Any, Nothing, zio.aws.entityresolution.model.ResolutionType] =
      ZIO.succeed(resolutionType)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
    def getWorkflowArn: ZIO[Any, Nothing, MatchingWorkflowArn] =
      ZIO.succeed(workflowArn)
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary
  ) extends zio.aws.entityresolution.model.MatchingWorkflowSummary.ReadOnly {
    override val createdAt: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.createdAt())
    override val resolutionType: zio.aws.entityresolution.model.ResolutionType =
      zio.aws.entityresolution.model.ResolutionType.wrap(impl.resolutionType())
    override val updatedAt: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.updatedAt())
    override val workflowArn: MatchingWorkflowArn =
      zio.aws.entityresolution.model.primitives
        .MatchingWorkflowArn(impl.workflowArn())
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary
  ): zio.aws.entityresolution.model.MatchingWorkflowSummary.ReadOnly =
    new Wrapper(impl)
}
