package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(tags: Map[TagKey, TagValue]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceResponse
      .builder()
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.entityresolution.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ListTagsForResourceResponse =
      zio.aws.entityresolution.model.ListTagsForResourceResponse(tags)
    def tags: Map[TagKey, TagValue]
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceResponse
  ) extends zio.aws.entityresolution.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.entityresolution.model.primitives.TagKey(
          key
        ) -> zio.aws.entityresolution.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceResponse
  ): zio.aws.entityresolution.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
