package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.VeniceGlobalArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: VeniceGlobalArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(VeniceGlobalArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.entityresolution.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ListTagsForResourceRequest =
      zio.aws.entityresolution.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: VeniceGlobalArn
    def getResourceArn: ZIO[Any, Nothing, VeniceGlobalArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceRequest
  ) extends zio.aws.entityresolution.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: VeniceGlobalArn =
      zio.aws.entityresolution.model.primitives
        .VeniceGlobalArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceRequest
  ): zio.aws.entityresolution.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
