package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSchemaMappingsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    schemaList: Optional[
      Iterable[zio.aws.entityresolution.model.SchemaMappingSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse = {
    import ListSchemaMappingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        schemaList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemaList)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListSchemaMappingsResponse.ReadOnly =
    zio.aws.entityresolution.model.ListSchemaMappingsResponse
      .wrap(buildAwsValue())
}
object ListSchemaMappingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ListSchemaMappingsResponse =
      zio.aws.entityresolution.model.ListSchemaMappingsResponse(
        nextToken.map(value => value),
        schemaList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def schemaList: Optional[
      List[zio.aws.entityresolution.model.SchemaMappingSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSchemaList: ZIO[Any, AwsError, List[
      zio.aws.entityresolution.model.SchemaMappingSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("schemaList", schemaList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse
  ) extends zio.aws.entityresolution.model.ListSchemaMappingsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.entityresolution.model.primitives.NextToken(value))
    override val schemaList: Optional[
      List[zio.aws.entityresolution.model.SchemaMappingSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.entityresolution.model.SchemaMappingSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse
  ): zio.aws.entityresolution.model.ListSchemaMappingsResponse.ReadOnly =
    new Wrapper(impl)
}
