package zio.aws.entityresolution.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.entityresolution.model.primitives.{
  NextToken,
  ListSchemaMappingsInputMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSchemaMappingsRequest(
    maxResults: Optional[ListSchemaMappingsInputMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest = {
    import ListSchemaMappingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListSchemaMappingsInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListSchemaMappingsRequest.ReadOnly =
    zio.aws.entityresolution.model.ListSchemaMappingsRequest
      .wrap(buildAwsValue())
}
object ListSchemaMappingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ListSchemaMappingsRequest =
      zio.aws.entityresolution.model.ListSchemaMappingsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListSchemaMappingsInputMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def getMaxResults
        : ZIO[Any, AwsError, ListSchemaMappingsInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest
  ) extends zio.aws.entityresolution.model.ListSchemaMappingsRequest.ReadOnly {
    override val maxResults
        : Optional[ListSchemaMappingsInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.entityresolution.model.primitives
            .ListSchemaMappingsInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.entityresolution.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest
  ): zio.aws.entityresolution.model.ListSchemaMappingsRequest.ReadOnly =
    new Wrapper(impl)
}
