package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListProviderServicesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    providerServiceSummaries: Optional[
      Iterable[zio.aws.entityresolution.model.ProviderServiceSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse = {
    import ListProviderServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        providerServiceSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.providerServiceSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListProviderServicesResponse.ReadOnly =
    zio.aws.entityresolution.model.ListProviderServicesResponse
      .wrap(buildAwsValue())
}
object ListProviderServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.ListProviderServicesResponse =
      zio.aws.entityresolution.model.ListProviderServicesResponse(
        nextToken.map(value => value),
        providerServiceSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def providerServiceSummaries: Optional[
      List[zio.aws.entityresolution.model.ProviderServiceSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProviderServiceSummaries: ZIO[Any, AwsError, List[
      zio.aws.entityresolution.model.ProviderServiceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "providerServiceSummaries",
      providerServiceSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse
  ) extends zio.aws.entityresolution.model.ListProviderServicesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.entityresolution.model.primitives.NextToken(value))
    override val providerServiceSummaries: Optional[
      List[zio.aws.entityresolution.model.ProviderServiceSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.providerServiceSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.entityresolution.model.ProviderServiceSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse
  ): zio.aws.entityresolution.model.ListProviderServicesResponse.ReadOnly =
    new Wrapper(impl)
}
