package zio.aws.entityresolution.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  NextToken,
  ListProviderServicesInputMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProviderServicesRequest(
    maxResults: Optional[ListProviderServicesInputMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    providerName: Optional[EntityName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest = {
    import ListProviderServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListProviderServicesInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        providerName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.providerName)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListProviderServicesRequest.ReadOnly =
    zio.aws.entityresolution.model.ListProviderServicesRequest
      .wrap(buildAwsValue())
}
object ListProviderServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ListProviderServicesRequest =
      zio.aws.entityresolution.model.ListProviderServicesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        providerName.map(value => value)
      )
    def maxResults: Optional[ListProviderServicesInputMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def providerName: Optional[EntityName]
    def getMaxResults
        : ZIO[Any, AwsError, ListProviderServicesInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProviderName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("providerName", providerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest
  ) extends zio.aws.entityresolution.model.ListProviderServicesRequest.ReadOnly {
    override val maxResults
        : Optional[ListProviderServicesInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.entityresolution.model.primitives
            .ListProviderServicesInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.entityresolution.model.primitives.NextToken(value))
    override val providerName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.providerName())
      .map(value => zio.aws.entityresolution.model.primitives.EntityName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest
  ): zio.aws.entityresolution.model.ListProviderServicesRequest.ReadOnly =
    new Wrapper(impl)
}
