package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMatchingWorkflowsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    workflowSummaries: Optional[
      Iterable[zio.aws.entityresolution.model.MatchingWorkflowSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse = {
    import ListMatchingWorkflowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        workflowSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflowSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListMatchingWorkflowsResponse.ReadOnly =
    zio.aws.entityresolution.model.ListMatchingWorkflowsResponse
      .wrap(buildAwsValue())
}
object ListMatchingWorkflowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.ListMatchingWorkflowsResponse =
      zio.aws.entityresolution.model.ListMatchingWorkflowsResponse(
        nextToken.map(value => value),
        workflowSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def workflowSummaries: Optional[
      List[zio.aws.entityresolution.model.MatchingWorkflowSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkflowSummaries: ZIO[Any, AwsError, List[
      zio.aws.entityresolution.model.MatchingWorkflowSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowSummaries", workflowSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse
  ) extends zio.aws.entityresolution.model.ListMatchingWorkflowsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.entityresolution.model.primitives.NextToken(value))
    override val workflowSummaries: Optional[
      List[zio.aws.entityresolution.model.MatchingWorkflowSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.entityresolution.model.MatchingWorkflowSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse
  ): zio.aws.entityresolution.model.ListMatchingWorkflowsResponse.ReadOnly =
    new Wrapper(impl)
}
