package zio.aws.entityresolution.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.entityresolution.model.primitives.{
  NextToken,
  ListMatchingWorkflowsInputMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMatchingWorkflowsRequest(
    maxResults: Optional[ListMatchingWorkflowsInputMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest = {
    import ListMatchingWorkflowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListMatchingWorkflowsInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListMatchingWorkflowsRequest.ReadOnly =
    zio.aws.entityresolution.model.ListMatchingWorkflowsRequest
      .wrap(buildAwsValue())
}
object ListMatchingWorkflowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.ListMatchingWorkflowsRequest =
      zio.aws.entityresolution.model.ListMatchingWorkflowsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListMatchingWorkflowsInputMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def getMaxResults
        : ZIO[Any, AwsError, ListMatchingWorkflowsInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest
  ) extends zio.aws.entityresolution.model.ListMatchingWorkflowsRequest.ReadOnly {
    override val maxResults
        : Optional[ListMatchingWorkflowsInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.entityresolution.model.primitives
            .ListMatchingWorkflowsInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.entityresolution.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest
  ): zio.aws.entityresolution.model.ListMatchingWorkflowsRequest.ReadOnly =
    new Wrapper(impl)
}
