package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMatchingJobsResponse(
    jobs: Optional[Iterable[zio.aws.entityresolution.model.JobSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse = {
    import ListMatchingJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse
      .builder()
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListMatchingJobsResponse.ReadOnly =
    zio.aws.entityresolution.model.ListMatchingJobsResponse
      .wrap(buildAwsValue())
}
object ListMatchingJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ListMatchingJobsResponse =
      zio.aws.entityresolution.model.ListMatchingJobsResponse(
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def jobs: Optional[List[zio.aws.entityresolution.model.JobSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getJobs: ZIO[Any, AwsError, List[
      zio.aws.entityresolution.model.JobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("jobs", jobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse
  ) extends zio.aws.entityresolution.model.ListMatchingJobsResponse.ReadOnly {
    override val jobs
        : Optional[List[zio.aws.entityresolution.model.JobSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.entityresolution.model.JobSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.entityresolution.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse
  ): zio.aws.entityresolution.model.ListMatchingJobsResponse.ReadOnly =
    new Wrapper(impl)
}
