package zio.aws.entityresolution.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  NextToken,
  ListMatchingJobsInputMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMatchingJobsRequest(
    maxResults: Optional[ListMatchingJobsInputMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    workflowName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest = {
    import ListMatchingJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListMatchingJobsInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListMatchingJobsRequest.ReadOnly =
    zio.aws.entityresolution.model.ListMatchingJobsRequest.wrap(buildAwsValue())
}
object ListMatchingJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ListMatchingJobsRequest =
      zio.aws.entityresolution.model.ListMatchingJobsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        workflowName
      )
    def maxResults: Optional[ListMatchingJobsInputMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def workflowName: EntityName
    def getMaxResults
        : ZIO[Any, AwsError, ListMatchingJobsInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest
  ) extends zio.aws.entityresolution.model.ListMatchingJobsRequest.ReadOnly {
    override val maxResults: Optional[ListMatchingJobsInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.entityresolution.model.primitives
            .ListMatchingJobsInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.entityresolution.model.primitives.NextToken(value))
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest
  ): zio.aws.entityresolution.model.ListMatchingJobsRequest.ReadOnly =
    new Wrapper(impl)
}
