package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListIdMappingWorkflowsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    workflowSummaries: Optional[
      Iterable[zio.aws.entityresolution.model.IdMappingWorkflowSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse = {
    import ListIdMappingWorkflowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        workflowSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflowSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse.ReadOnly =
    zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse
      .wrap(buildAwsValue())
}
object ListIdMappingWorkflowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse =
      zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse(
        nextToken.map(value => value),
        workflowSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def workflowSummaries: Optional[
      List[zio.aws.entityresolution.model.IdMappingWorkflowSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkflowSummaries: ZIO[Any, AwsError, List[
      zio.aws.entityresolution.model.IdMappingWorkflowSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowSummaries", workflowSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse
  ) extends zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.entityresolution.model.primitives.NextToken(value))
    override val workflowSummaries: Optional[
      List[zio.aws.entityresolution.model.IdMappingWorkflowSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.entityresolution.model.IdMappingWorkflowSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse
  ): zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse.ReadOnly =
    new Wrapper(impl)
}
