package zio.aws.entityresolution.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.entityresolution.model.primitives.{
  NextToken,
  ListIdMappingWorkflowsInputMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListIdMappingWorkflowsRequest(
    maxResults: Optional[ListIdMappingWorkflowsInputMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest = {
    import ListIdMappingWorkflowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListIdMappingWorkflowsInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListIdMappingWorkflowsRequest.ReadOnly =
    zio.aws.entityresolution.model.ListIdMappingWorkflowsRequest
      .wrap(buildAwsValue())
}
object ListIdMappingWorkflowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.ListIdMappingWorkflowsRequest =
      zio.aws.entityresolution.model.ListIdMappingWorkflowsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListIdMappingWorkflowsInputMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def getMaxResults
        : ZIO[Any, AwsError, ListIdMappingWorkflowsInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest
  ) extends zio.aws.entityresolution.model.ListIdMappingWorkflowsRequest.ReadOnly {
    override val maxResults
        : Optional[ListIdMappingWorkflowsInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.entityresolution.model.primitives
            .ListIdMappingWorkflowsInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.entityresolution.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest
  ): zio.aws.entityresolution.model.ListIdMappingWorkflowsRequest.ReadOnly =
    new Wrapper(impl)
}
