package zio.aws.entityresolution.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  NextToken,
  ListIdMappingJobsInputMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListIdMappingJobsRequest(
    maxResults: Optional[ListIdMappingJobsInputMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    workflowName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest = {
    import ListIdMappingJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListIdMappingJobsInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.ListIdMappingJobsRequest.ReadOnly =
    zio.aws.entityresolution.model.ListIdMappingJobsRequest
      .wrap(buildAwsValue())
}
object ListIdMappingJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ListIdMappingJobsRequest =
      zio.aws.entityresolution.model.ListIdMappingJobsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        workflowName
      )
    def maxResults: Optional[ListIdMappingJobsInputMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def workflowName: EntityName
    def getMaxResults
        : ZIO[Any, AwsError, ListIdMappingJobsInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest
  ) extends zio.aws.entityresolution.model.ListIdMappingJobsRequest.ReadOnly {
    override val maxResults: Optional[ListIdMappingJobsInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.entityresolution.model.primitives
            .ListIdMappingJobsInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.entityresolution.model.primitives.NextToken(value))
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest
  ): zio.aws.entityresolution.model.ListIdMappingJobsRequest.ReadOnly =
    new Wrapper(impl)
}
