package zio.aws.entityresolution.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.entityresolution.model.primitives.{JobId, Timestamp}
import scala.jdk.CollectionConverters._
final case class JobSummary(
    endTime: Optional[Timestamp] = Optional.Absent,
    jobId: JobId,
    startTime: Timestamp,
    status: zio.aws.entityresolution.model.JobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.JobSummary = {
    import JobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.JobSummary
      .builder()
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.JobSummary.ReadOnly =
    zio.aws.entityresolution.model.JobSummary.wrap(buildAwsValue())
}
object JobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.JobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.JobSummary =
      zio.aws.entityresolution.model.JobSummary(
        endTime.map(value => value),
        jobId,
        startTime,
        status
      )
    def endTime: Optional[Timestamp]
    def jobId: JobId
    def startTime: Timestamp
    def status: zio.aws.entityresolution.model.JobStatus
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getStatus: ZIO[Any, Nothing, zio.aws.entityresolution.model.JobStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.JobSummary
  ) extends zio.aws.entityresolution.model.JobSummary.ReadOnly {
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.entityresolution.model.primitives.Timestamp(value))
    override val jobId: JobId =
      zio.aws.entityresolution.model.primitives.JobId(impl.jobId())
    override val startTime: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.startTime())
    override val status: zio.aws.entityresolution.model.JobStatus =
      zio.aws.entityresolution.model.JobStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.JobSummary
  ): zio.aws.entityresolution.model.JobSummary.ReadOnly = new Wrapper(impl)
}
