package zio.aws.entityresolution.model
import scala.jdk.CollectionConverters._
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.entityresolution.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.entityresolution.model.JobStatus
  ): zio.aws.entityresolution.model.JobStatus = value match {
    case software.amazon.awssdk.services.entityresolution.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.entityresolution.model.JobStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.entityresolution.model.JobStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.entityresolution.model.JobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.entityresolution.model.JobStatus.QUEUED =>
      val r = QUEUED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.entityresolution.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.JobStatus =
      software.amazon.awssdk.services.entityresolution.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.entityresolution.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.JobStatus =
      software.amazon.awssdk.services.entityresolution.model.JobStatus.RUNNING
  }
  case object SUCCEEDED extends zio.aws.entityresolution.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.JobStatus =
      software.amazon.awssdk.services.entityresolution.model.JobStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.entityresolution.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.JobStatus =
      software.amazon.awssdk.services.entityresolution.model.JobStatus.FAILED
  }
  case object QUEUED extends zio.aws.entityresolution.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.JobStatus =
      software.amazon.awssdk.services.entityresolution.model.JobStatus.QUEUED
  }
}
