package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobMetrics(
    inputRecords: Optional[Integer] = Optional.Absent,
    matchIDs: Optional[Integer] = Optional.Absent,
    recordsNotProcessed: Optional[Integer] = Optional.Absent,
    totalRecordsProcessed: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.JobMetrics = {
    import JobMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.JobMetrics
      .builder()
      .optionallyWith(inputRecords.map(value => value: java.lang.Integer))(
        _.inputRecords
      )
      .optionallyWith(matchIDs.map(value => value: java.lang.Integer))(
        _.matchIDs
      )
      .optionallyWith(
        recordsNotProcessed.map(value => value: java.lang.Integer)
      )(_.recordsNotProcessed)
      .optionallyWith(
        totalRecordsProcessed.map(value => value: java.lang.Integer)
      )(_.totalRecordsProcessed)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.JobMetrics.ReadOnly =
    zio.aws.entityresolution.model.JobMetrics.wrap(buildAwsValue())
}
object JobMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.JobMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.JobMetrics =
      zio.aws.entityresolution.model.JobMetrics(
        inputRecords.map(value => value),
        matchIDs.map(value => value),
        recordsNotProcessed.map(value => value),
        totalRecordsProcessed.map(value => value)
      )
    def inputRecords: Optional[Integer]
    def matchIDs: Optional[Integer]
    def recordsNotProcessed: Optional[Integer]
    def totalRecordsProcessed: Optional[Integer]
    def getInputRecords: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("inputRecords", inputRecords)
    def getMatchIDs: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("matchIDs", matchIDs)
    def getRecordsNotProcessed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("recordsNotProcessed", recordsNotProcessed)
    def getTotalRecordsProcessed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalRecordsProcessed", totalRecordsProcessed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.JobMetrics
  ) extends zio.aws.entityresolution.model.JobMetrics.ReadOnly {
    override val inputRecords: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.inputRecords())
      .map(value => value: Integer)
    override val matchIDs: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.matchIDs())
      .map(value => value: Integer)
    override val recordsNotProcessed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.recordsNotProcessed())
      .map(value => value: Integer)
    override val totalRecordsProcessed: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalRecordsProcessed())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.JobMetrics
  ): zio.aws.entityresolution.model.JobMetrics.ReadOnly = new Wrapper(impl)
}
