package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.S3Path
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IntermediateSourceConfiguration(intermediateS3Path: S3Path) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.IntermediateSourceConfiguration = {
    import IntermediateSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.IntermediateSourceConfiguration
      .builder()
      .intermediateS3Path(S3Path.unwrap(intermediateS3Path): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.IntermediateSourceConfiguration.ReadOnly =
    zio.aws.entityresolution.model.IntermediateSourceConfiguration
      .wrap(buildAwsValue())
}
object IntermediateSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.IntermediateSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.IntermediateSourceConfiguration =
      zio.aws.entityresolution.model
        .IntermediateSourceConfiguration(intermediateS3Path)
    def intermediateS3Path: S3Path
    def getIntermediateS3Path: ZIO[Any, Nothing, S3Path] =
      ZIO.succeed(intermediateS3Path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.IntermediateSourceConfiguration
  ) extends zio.aws.entityresolution.model.IntermediateSourceConfiguration.ReadOnly {
    override val intermediateS3Path: S3Path =
      zio.aws.entityresolution.model.primitives
        .S3Path(impl.intermediateS3Path())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.IntermediateSourceConfiguration
  ): zio.aws.entityresolution.model.IntermediateSourceConfiguration.ReadOnly =
    new Wrapper(impl)
}
