package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  InputSourceInputSourceARNString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputSource(
    applyNormalization: Optional[Boolean] = Optional.Absent,
    inputSourceARN: InputSourceInputSourceARNString,
    schemaName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.InputSource = {
    import InputSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.InputSource
      .builder()
      .optionallyWith(
        applyNormalization.map(value => value: java.lang.Boolean)
      )(_.applyNormalization)
      .inputSourceARN(
        InputSourceInputSourceARNString.unwrap(inputSourceARN): java.lang.String
      )
      .schemaName(EntityName.unwrap(schemaName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.InputSource.ReadOnly =
    zio.aws.entityresolution.model.InputSource.wrap(buildAwsValue())
}
object InputSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.InputSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.InputSource =
      zio.aws.entityresolution.model.InputSource(
        applyNormalization.map(value => value),
        inputSourceARN,
        schemaName
      )
    def applyNormalization: Optional[Boolean]
    def inputSourceARN: InputSourceInputSourceARNString
    def schemaName: EntityName
    def getApplyNormalization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyNormalization", applyNormalization)
    def getInputSourceARN: ZIO[Any, Nothing, InputSourceInputSourceARNString] =
      ZIO.succeed(inputSourceARN)
    def getSchemaName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(schemaName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.InputSource
  ) extends zio.aws.entityresolution.model.InputSource.ReadOnly {
    override val applyNormalization: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyNormalization())
      .map(value => value: Boolean)
    override val inputSourceARN: InputSourceInputSourceARNString =
      zio.aws.entityresolution.model.primitives
        .InputSourceInputSourceARNString(impl.inputSourceARN())
    override val schemaName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.schemaName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.InputSource
  ): zio.aws.entityresolution.model.InputSource.ReadOnly = new Wrapper(impl)
}
