package zio.aws.entityresolution.model
import scala.jdk.CollectionConverters._
sealed trait IncrementalRunType {
  def unwrap: software.amazon.awssdk.services.entityresolution.model.IncrementalRunType
}
object IncrementalRunType {
  def wrap(
      value: software.amazon.awssdk.services.entityresolution.model.IncrementalRunType
  ): zio.aws.entityresolution.model.IncrementalRunType = value match {
    case software.amazon.awssdk.services.entityresolution.model.IncrementalRunType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.entityresolution.model.IncrementalRunType.IMMEDIATE =>
      val r = IMMEDIATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.entityresolution.model.IncrementalRunType {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.IncrementalRunType =
      software.amazon.awssdk.services.entityresolution.model.IncrementalRunType.UNKNOWN_TO_SDK_VERSION
  }
  case object IMMEDIATE
      extends zio.aws.entityresolution.model.IncrementalRunType {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.IncrementalRunType =
      software.amazon.awssdk.services.entityresolution.model.IncrementalRunType.IMMEDIATE
  }
}
