package zio.aws.entityresolution.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IncrementalRunConfig(
    incrementalRunType: Optional[
      zio.aws.entityresolution.model.IncrementalRunType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.IncrementalRunConfig = {
    import IncrementalRunConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.IncrementalRunConfig
      .builder()
      .optionallyWith(incrementalRunType.map(value => value.unwrap))(
        _.incrementalRunType
      )
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.IncrementalRunConfig.ReadOnly =
    zio.aws.entityresolution.model.IncrementalRunConfig.wrap(buildAwsValue())
}
object IncrementalRunConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.IncrementalRunConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.IncrementalRunConfig =
      zio.aws.entityresolution.model
        .IncrementalRunConfig(incrementalRunType.map(value => value))
    def incrementalRunType
        : Optional[zio.aws.entityresolution.model.IncrementalRunType]
    def getIncrementalRunType: ZIO[
      Any,
      AwsError,
      zio.aws.entityresolution.model.IncrementalRunType
    ] = AwsError.unwrapOptionField("incrementalRunType", incrementalRunType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.IncrementalRunConfig
  ) extends zio.aws.entityresolution.model.IncrementalRunConfig.ReadOnly {
    override val incrementalRunType
        : Optional[zio.aws.entityresolution.model.IncrementalRunType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.incrementalRunType())
        .map(value =>
          zio.aws.entityresolution.model.IncrementalRunType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.IncrementalRunConfig
  ): zio.aws.entityresolution.model.IncrementalRunConfig.ReadOnly = new Wrapper(
    impl
  )
}
