package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  IdMappingWorkflowArn,
  Timestamp
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class IdMappingWorkflowSummary(
    createdAt: Timestamp,
    updatedAt: Timestamp,
    workflowArn: IdMappingWorkflowArn,
    workflowName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowSummary = {
    import IdMappingWorkflowSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowSummary
      .builder()
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .workflowArn(IdMappingWorkflowArn.unwrap(workflowArn): java.lang.String)
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.IdMappingWorkflowSummary.ReadOnly =
    zio.aws.entityresolution.model.IdMappingWorkflowSummary
      .wrap(buildAwsValue())
}
object IdMappingWorkflowSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.IdMappingWorkflowSummary =
      zio.aws.entityresolution.model.IdMappingWorkflowSummary(
        createdAt,
        updatedAt,
        workflowArn,
        workflowName
      )
    def createdAt: Timestamp
    def updatedAt: Timestamp
    def workflowArn: IdMappingWorkflowArn
    def workflowName: EntityName
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
    def getWorkflowArn: ZIO[Any, Nothing, IdMappingWorkflowArn] =
      ZIO.succeed(workflowArn)
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowSummary
  ) extends zio.aws.entityresolution.model.IdMappingWorkflowSummary.ReadOnly {
    override val createdAt: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.createdAt())
    override val updatedAt: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.updatedAt())
    override val workflowArn: IdMappingWorkflowArn =
      zio.aws.entityresolution.model.primitives
        .IdMappingWorkflowArn(impl.workflowArn())
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowSummary
  ): zio.aws.entityresolution.model.IdMappingWorkflowSummary.ReadOnly =
    new Wrapper(impl)
}
