package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{S3Path, KMSArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IdMappingWorkflowOutputSource(
    kmsArn: Optional[KMSArn] = Optional.Absent,
    outputS3Path: S3Path
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowOutputSource = {
    import IdMappingWorkflowOutputSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowOutputSource
      .builder()
      .optionallyWith(
        kmsArn.map(value => KMSArn.unwrap(value): java.lang.String)
      )(_.kmsArn)
      .outputS3Path(S3Path.unwrap(outputS3Path): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.IdMappingWorkflowOutputSource.ReadOnly =
    zio.aws.entityresolution.model.IdMappingWorkflowOutputSource
      .wrap(buildAwsValue())
}
object IdMappingWorkflowOutputSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowOutputSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.IdMappingWorkflowOutputSource =
      zio.aws.entityresolution.model
        .IdMappingWorkflowOutputSource(kmsArn.map(value => value), outputS3Path)
    def kmsArn: Optional[KMSArn]
    def outputS3Path: S3Path
    def getKmsArn: ZIO[Any, AwsError, KMSArn] =
      AwsError.unwrapOptionField("kmsArn", kmsArn)
    def getOutputS3Path: ZIO[Any, Nothing, S3Path] = ZIO.succeed(outputS3Path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowOutputSource
  ) extends zio.aws.entityresolution.model.IdMappingWorkflowOutputSource.ReadOnly {
    override val kmsArn: Optional[KMSArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsArn())
      .map(value => zio.aws.entityresolution.model.primitives.KMSArn(value))
    override val outputS3Path: S3Path =
      zio.aws.entityresolution.model.primitives.S3Path(impl.outputS3Path())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowOutputSource
  ): zio.aws.entityresolution.model.IdMappingWorkflowOutputSource.ReadOnly =
    new Wrapper(impl)
}
