package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  IdMappingWorkflowInputSourceInputSourceARNString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IdMappingWorkflowInputSource(
    inputSourceARN: IdMappingWorkflowInputSourceInputSourceARNString,
    schemaName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowInputSource = {
    import IdMappingWorkflowInputSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowInputSource
      .builder()
      .inputSourceARN(
        IdMappingWorkflowInputSourceInputSourceARNString.unwrap(
          inputSourceARN
        ): java.lang.String
      )
      .schemaName(EntityName.unwrap(schemaName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.IdMappingWorkflowInputSource.ReadOnly =
    zio.aws.entityresolution.model.IdMappingWorkflowInputSource
      .wrap(buildAwsValue())
}
object IdMappingWorkflowInputSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowInputSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.IdMappingWorkflowInputSource =
      zio.aws.entityresolution.model
        .IdMappingWorkflowInputSource(inputSourceARN, schemaName)
    def inputSourceARN: IdMappingWorkflowInputSourceInputSourceARNString
    def schemaName: EntityName
    def getInputSourceARN
        : ZIO[Any, Nothing, IdMappingWorkflowInputSourceInputSourceARNString] =
      ZIO.succeed(inputSourceARN)
    def getSchemaName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(schemaName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowInputSource
  ) extends zio.aws.entityresolution.model.IdMappingWorkflowInputSource.ReadOnly {
    override val inputSourceARN
        : IdMappingWorkflowInputSourceInputSourceARNString =
      zio.aws.entityresolution.model.primitives
        .IdMappingWorkflowInputSourceInputSourceARNString(impl.inputSourceARN())
    override val schemaName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.schemaName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowInputSource
  ): zio.aws.entityresolution.model.IdMappingWorkflowInputSource.ReadOnly =
    new Wrapper(impl)
}
