package zio.aws.entityresolution.model
import scala.jdk.CollectionConverters._
sealed trait IdMappingType {
  def unwrap
      : software.amazon.awssdk.services.entityresolution.model.IdMappingType
}
object IdMappingType {
  def wrap(
      value: software.amazon.awssdk.services.entityresolution.model.IdMappingType
  ): zio.aws.entityresolution.model.IdMappingType = value match {
    case software.amazon.awssdk.services.entityresolution.model.IdMappingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.entityresolution.model.IdMappingType.PROVIDER =>
      val r = PROVIDER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.entityresolution.model.IdMappingType {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.IdMappingType =
      software.amazon.awssdk.services.entityresolution.model.IdMappingType.UNKNOWN_TO_SDK_VERSION
  }
  case object PROVIDER extends zio.aws.entityresolution.model.IdMappingType {
    override def unwrap
        : software.amazon.awssdk.services.entityresolution.model.IdMappingType =
      software.amazon.awssdk.services.entityresolution.model.IdMappingType.PROVIDER
  }
}
