package zio.aws.entityresolution.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IdMappingTechniques(
    idMappingType: zio.aws.entityresolution.model.IdMappingType,
    providerProperties: zio.aws.entityresolution.model.ProviderProperties
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.IdMappingTechniques = {
    import IdMappingTechniques.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.IdMappingTechniques
      .builder()
      .idMappingType(idMappingType.unwrap)
      .providerProperties(providerProperties.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.IdMappingTechniques.ReadOnly =
    zio.aws.entityresolution.model.IdMappingTechniques.wrap(buildAwsValue())
}
object IdMappingTechniques {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.IdMappingTechniques
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.IdMappingTechniques =
      zio.aws.entityresolution.model
        .IdMappingTechniques(idMappingType, providerProperties.asEditable)
    def idMappingType: zio.aws.entityresolution.model.IdMappingType
    def providerProperties
        : zio.aws.entityresolution.model.ProviderProperties.ReadOnly
    def getIdMappingType
        : ZIO[Any, Nothing, zio.aws.entityresolution.model.IdMappingType] =
      ZIO.succeed(idMappingType)
    def getProviderProperties: ZIO[
      Any,
      Nothing,
      zio.aws.entityresolution.model.ProviderProperties.ReadOnly
    ] = ZIO.succeed(providerProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.IdMappingTechniques
  ) extends zio.aws.entityresolution.model.IdMappingTechniques.ReadOnly {
    override val idMappingType: zio.aws.entityresolution.model.IdMappingType =
      zio.aws.entityresolution.model.IdMappingType.wrap(impl.idMappingType())
    override val providerProperties
        : zio.aws.entityresolution.model.ProviderProperties.ReadOnly =
      zio.aws.entityresolution.model.ProviderProperties
        .wrap(impl.providerProperties())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.IdMappingTechniques
  ): zio.aws.entityresolution.model.IdMappingTechniques.ReadOnly = new Wrapper(
    impl
  )
}
