package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IdMappingJobMetrics(
    inputRecords: Optional[Integer] = Optional.Absent,
    recordsNotProcessed: Optional[Integer] = Optional.Absent,
    totalRecordsProcessed: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.IdMappingJobMetrics = {
    import IdMappingJobMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.IdMappingJobMetrics
      .builder()
      .optionallyWith(inputRecords.map(value => value: java.lang.Integer))(
        _.inputRecords
      )
      .optionallyWith(
        recordsNotProcessed.map(value => value: java.lang.Integer)
      )(_.recordsNotProcessed)
      .optionallyWith(
        totalRecordsProcessed.map(value => value: java.lang.Integer)
      )(_.totalRecordsProcessed)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.IdMappingJobMetrics.ReadOnly =
    zio.aws.entityresolution.model.IdMappingJobMetrics.wrap(buildAwsValue())
}
object IdMappingJobMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.IdMappingJobMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.IdMappingJobMetrics =
      zio.aws.entityresolution.model.IdMappingJobMetrics(
        inputRecords.map(value => value),
        recordsNotProcessed.map(value => value),
        totalRecordsProcessed.map(value => value)
      )
    def inputRecords: Optional[Integer]
    def recordsNotProcessed: Optional[Integer]
    def totalRecordsProcessed: Optional[Integer]
    def getInputRecords: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("inputRecords", inputRecords)
    def getRecordsNotProcessed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("recordsNotProcessed", recordsNotProcessed)
    def getTotalRecordsProcessed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalRecordsProcessed", totalRecordsProcessed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.IdMappingJobMetrics
  ) extends zio.aws.entityresolution.model.IdMappingJobMetrics.ReadOnly {
    override val inputRecords: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.inputRecords())
      .map(value => value: Integer)
    override val recordsNotProcessed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.recordsNotProcessed())
      .map(value => value: Integer)
    override val totalRecordsProcessed: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalRecordsProcessed())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.IdMappingJobMetrics
  ): zio.aws.entityresolution.model.IdMappingJobMetrics.ReadOnly = new Wrapper(
    impl
  )
}
